function isEmail(email) {
	var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	return regex.test(email);
}

function ProcessNewsletterErrors() {
	var email	= $("#newsletter-form .form-line-email"),
		captcha = $("#newsletter-form .form-line-image_code"),
		form	= $("#newsletter-form "),
		response= $("#newsletter-form .responsebox .alert"),
		field	= null;
		
	form.find(".form-line.error").click(function(e) {
		e.stopPropagation();
		e.preventDefault();
	});
	
	if (email.hasClass("error") && captcha.length) {
		email.removeClass("fadeOutLeftBig").addClass("fadeInLeftBig");
		captcha.addClass("fadeInRightBig").addClass("fadeOutRightBig");
	}

	if (email.hasClass("error")) {
		field = email;
	} else if (captcha.hasClass("error")) {
		field = captcha;
	} else if (!email.hasClass("error") && !captcha.hasClass("error") && response.length) {

	}

	if (field !== null) {
		setTimeout(function(){ 
			//fly the error message
			field.find(".form-line-error").addClass("animated fadeOutLeftBig");

			//remove phisicaly the error message
			setTimeout(function() {
				field.find(".form-line-error").remove();
				field.removeClass("error");
			} , 3000);
		} , 3000);
	} 

	if (!email.hasClass("error") && !captcha.hasClass("error") && response.length) {
		setTimeout(function() {
			response.addClass("animated fadeOutLeftBig");
			if (captcha.length) {
				email.removeClass("fadeOutLeftBig").addClass("fadeInLeftBig");
				captcha.addClass("fadeInRightBig").addClass("fadeOutRightBig");
			}

			setTimeout(function() {


				response.remove();
			} , 3000);
		}, 3000);
	}
}

$(document).ready(function() {

	var max = 0;
	$("#newsletter-form .btn").each(function() {
		max = Math.max($(this).width() , max);
	});

	$("#newsletter-form .btn").width(max);

	$("#newsletter-form button[type=submit]").click(function() {
		$("#newsletter-form").trigger("submit");
	})

	
	$(".btn-next-step").click(function() {
		var parent = $(this).closest(".form-line"),
			captcha = parent.siblings(".form-line-image_code"),
			form = $(this).closest("form");			

			if (!isEmail(form.find("input[name=email]").val())) 	{
				var msg = parent.attr("data-email-error");
				setTimeout(function() {
					parent.append(
						'<div ' + 
						'class="form-line-error" ' + 
						'>' + 
							'<div class="alert alert-danger"><p>' + msg + '</p></div>' + 
						'</div>');
					parent.addClass("error");
				
					setTimeout(function(){ 
							//fly the error message
							parent.find(".form-line-error").addClass("animated fadeOutLeftBig");

							//remove phisicaly the error message
							setTimeout(function() {
								parent.find(".form-line-error").remove();
								parent.removeClass("error");
							} , 3000);

						} , 3000);

				} , 100);

				parent.click(function(e) {
					e.stopPropagation();
					e.preventDefault();
				});


			}  else {

				if (captcha.length) {

						parent.removeClass("animated fadeInRightBig");
						setTimeout(function() {
							parent.addClass("animated fadeOutLeftBig");
							captcha.removeClass("fadeOutRightBig hide").addClass("animated fadeInRightBig");


							if (captcha.hasClass("error")){
								setTimeout(function(){ 
									//fly the error message
									captcha.find(".form-line-error").addClass("animated fadeOutLeftBig");

									//remove phisicaly the error message
									setTimeout(function() {
										captcha.find(".form-line-error").remove();
										captcha.removeClass("error");
									} , 3000);
								} , 3000);
							}

						});
				} else {
					form.trigger("submit");
				}
			}		
	});

});	